-- Önceki güncellemelerin üzerine ek olarak:

-- 1. Firms Tablosu Güncellemeleri
ALTER TABLE `firms`
ADD COLUMN `website` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `working_hours`,
ADD COLUMN `email` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `website`,
ADD COLUMN `logo_url` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `image_url`,
ADD COLUMN `description` varchar(500) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `name`, -- Kısa Açıklama
ADD COLUMN `rating` decimal(3,2) DEFAULT 0.00 AFTER `is_featured`;

-- 2. Categories Tablosu Güncellemeleri
ALTER TABLE `categories`
ADD COLUMN `description` text COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `slug`,
ADD COLUMN `title` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `name`;

-- 3. Subcategories Tablosu Güncellemeleri
ALTER TABLE `subcategories`
ADD COLUMN `description` text COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `name`,
ADD COLUMN `icon_url` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `description`,
ADD COLUMN `title` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `name`;

-- 4. Important Numbers Güncellemeleri
ALTER TABLE `important_numbers`
ADD COLUMN `category` varchar(100) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `name`,
ADD COLUMN `description` text COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `category`;

-- 5. Events Güncellemeleri
ALTER TABLE `events`
ADD COLUMN `contact` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `organizer`,
ADD COLUMN `latitude` double DEFAULT NULL AFTER `location`,
ADD COLUMN `longitude` double DEFAULT NULL AFTER `latitude`,
ADD COLUMN `is_new` tinyint(1) DEFAULT 0 AFTER `contact`;

-- 6. News Güncellemeleri
ALTER TABLE `news`
ADD COLUMN `source` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL AFTER `content`;

-- 7. Notifications Tablosu (Yeni)
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_turkish_ci NOT NULL,
  `body` text COLLATE utf8mb4_turkish_ci NOT NULL,
  `image_url` varchar(255) COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `sent_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;
