<?php
// API Şifresi
define('API_KEY', 'Ulucak-030410088');

// API Key Doğrulama
function checkApiKey() {
    $apiKey = $_GET['api_key'] ?? $_POST['api_key'] ?? $_SERVER['HTTP_X_API_KEY'] ?? '';
    if ($apiKey !== API_KEY) {
        sendResponse('error', 'Geçersiz API anahtarı');
    }
}

// JSON Yanıt Yardımcısı
function sendResponse($status, $message, $data = null) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'status' => $status,
        'message' => $message,
        'data' => $data
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Güvenli String Temizleme
function cleanInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

/**
 * Güvenli Resim Yükleme Fonksiyonu
 * @param array $file $_FILES['input_name']
 * @param string $uploadDir Yüklenecek dizin (sonunda / olmalı)
 * @param string $prefix Dosya adı ön eki
 * @return string Yüklenen dosyanın yolu 'uploads/dosya.jpg'
 * @throws Exception Hata durumunda
 */
function uploadImage($file, $uploadDir, $prefix = '') {
    if (empty($file['name']) || $file['error'] !== UPLOAD_ERR_OK) {
        return null;
    }

    // İzin verilen uzantılar ve MIME tipleri
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'webp'];
    $allowedMimeTypes = ['image/jpeg', 'image/png', 'image/webp'];

    $fileInfo = pathinfo($file['name']);
    $extension = strtolower($fileInfo['extension']);
    
    // mime_content_type kontrolü
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $file['tmp_name']);
    finfo_close($finfo);

    if (!in_array($extension, $allowedExtensions) || !in_array($mimeType, $allowedMimeTypes)) {
        throw new Exception("Geçersiz dosya formatı. Sadece JPG, PNG ve WEBP kabul edilir.");
    }

    // Dosya boyutu kontrolü (Max 5MB)
    if ($file['size'] > 5 * 1024 * 1024) {
        throw new Exception("Dosya boyutu çok büyük (Max 5MB).");
    }

    // Klasör kontrolü
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // Benzersiz dosya adı
    $fileName = $prefix . time() . '_' . bin2hex(random_bytes(4)) . '.' . $extension;
    $targetPath = $uploadDir . $fileName;

    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        return 'uploads/' . $fileName;
    }

    throw new Exception("Dosya yüklenirken bir hata oluştu.");
}
?>
