<?php
require_once '../config/db.php';
require_once '../config/functions.php';

checkApiKey(); // API şifre kontrolü

// Filtreleme Parametreleri
$category_id = isset($_GET['cat_id']) ? cleanInput($_GET['cat_id']) : null;
$subcategory_id = isset($_GET['sub_cat_id']) ? cleanInput($_GET['sub_cat_id']) : null;
$search_query = isset($_GET['search']) ? cleanInput($_GET['search']) : null;
$featured = isset($_GET['featured']) ? true : false; // Vitrin/Öne çıkanlar

// SQL Sorgusunu Hazırla
// Tüm detayları (content, working_hours, is_featured) çekiyoruz
$sql = "SELECT f.*, c.name as category_name, c.icon_url as category_icon, s.name as subcategory_name 
        FROM firms f 
        LEFT JOIN categories c ON f.category_id = c.id 
        LEFT JOIN subcategories s ON f.subcategory_id = s.id
        WHERE f.is_active = 1";
$params = [];

// Kategori Filtresi
if ($category_id) {
    $sql .= " AND f.category_id = :cat_id";
    $params[':cat_id'] = $category_id;
}

// Alt Kategori Filtresi
if ($subcategory_id) {
    $sql .= " AND f.subcategory_id = :sub_cat_id";
    $params[':sub_cat_id'] = $subcategory_id;
}

// Vitrin Filtresi
if ($featured) {
    $sql .= " AND f.is_featured = 1";
}

// Arama Filtresi (Ad, Yetkili, Adres veya İçerik içinde ara)
if ($search_query) {
    $sql .= " AND (f.name LIKE :search OR f.owner LIKE :search OR f.address LIKE :search OR f.content LIKE :search)";
    $params[':search'] = "%$search_query%";
}

// Sıralama (Öne çıkanlar önce, sonra görüntülenme veya isim)
$sql .= " ORDER BY f.is_featured DESC, f.views DESC, f.name ASC";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $firms = $stmt->fetchAll();

    if ($firms) {
        sendResponse('success', 'Firmalar listelendi', $firms);
    } else {
        sendResponse('success', 'Kayıt bulunamadı', []);
    }
} catch (PDOException $e) {
    sendResponse('error', 'Veritabanı hatası: ' . $e->getMessage());
}
?>
