<?php
require_once '../config/db.php';
require_once '../config/functions.php';

checkApiKey(); // API şifre kontrolü

try {
    // Gelecek etkinlikler veya tümü? Şimdilik tarihe göre sıralı hepsi.
    // Opsiyonel: Sadece gelecekteki etkinlikler için WHERE event_date >= NOW() eklenebilir.
    $stmt = $pdo->query("SELECT * FROM events ORDER BY event_date ASC");
    $events = $stmt->fetchAll();

    if ($events) {
        sendResponse('success', 'Etkinlikler listelendi', $events);
    } else {
        sendResponse('success', 'Etkinlik bulunamadı', []);
    }
} catch (PDOException $e) {
    sendResponse('error', 'Veritabanı hatası: ' . $e->getMessage());
}
?>
