<?php
require_once '../config/db.php';
require_once '../config/functions.php';

checkApiKey(); // API şifre kontrolü

// Tüm kategorileri ve alt kategorilerini getir
try {
    // Önce ana kategorileri çek
    $stmt = $pdo->query("SELECT * FROM categories ORDER BY rank_order ASC, name ASC");
    $categories = $stmt->fetchAll();

    // Sonuç dizisi
    $result = [];

    foreach ($categories as $cat) {
        // Bu kategoriye ait alt kategorileri çek
        $stmt_sub = $pdo->prepare("SELECT * FROM subcategories WHERE category_id = ? ORDER BY rank_order ASC, name ASC");
        $stmt_sub->execute([$cat['id']]);
        $subcategories = $stmt_sub->fetchAll();

        // Kategori verisine alt kategorileri ekle
        $cat['subcategories'] = $subcategories;
        $result[] = $cat;
    }
    
    sendResponse('success', 'Kategoriler getirildi', $result);
} catch (PDOException $e) {
    sendResponse('error', 'Veritabanı hatası: ' . $e->getMessage());
}
?>
