<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$category_id = isset($_GET['cat_id']) ? (int)$_GET['cat_id'] : 0;
if (!$category_id) {
    header("Location: categories.php");
    exit;
}

// Ana Kategori Bilgisi
$stmt = $pdo->prepare("SELECT * FROM categories WHERE id = ?");
$stmt->execute([$category_id]);
$main_category = $stmt->fetch();

if (!$main_category) {
    die("Kategori bulunamadı.");
}

$message = "";
$error = "";

// Ekleme / Güncelleme / Silme
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    $name = cleanInput($_POST['name']);
    $rank_order = (int)$_POST['rank_order'];

    if ($action == 'delete') {
        $id = (int)$_POST['id'];
        $stmt = $pdo->prepare("DELETE FROM subcategories WHERE id = ?");
        if ($stmt->execute([$id])) {
            $message = "Alt kategori silindi.";
        } else {
            $error = "Silme başarısız.";
        }
    } elseif (empty($name)) {
        $error = "Alt kategori adı boş olamaz.";
    } else {
        if ($action == 'add') {
            $stmt = $pdo->prepare("INSERT INTO subcategories (category_id, name, rank_order) VALUES (?, ?, ?)");
            if ($stmt->execute([$category_id, $name, $rank_order])) {
                $message = "Alt kategori eklendi.";
            } else {
                $error = "Ekleme başarısız.";
            }
        } elseif ($action == 'edit') {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("UPDATE subcategories SET name = ?, rank_order = ? WHERE id = ?");
            if ($stmt->execute([$name, $rank_order, $id])) {
                $message = "Alt kategori güncellendi.";
            } else {
                $error = "Güncelleme başarısız.";
            }
        }
    }
}

// Alt Kategorileri Listele
$subcategories = $pdo->prepare("SELECT * FROM subcategories WHERE category_id = ? ORDER BY rank_order ASC");
$subcategories->execute([$category_id]);
$list = $subcategories->fetchAll();

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">
        <a href="categories.php" class="text-decoration-none text-muted"><i class="fas fa-arrow-left"></i></a> 
        <?php echo $main_category['name']; ?> - Alt Kategoriler
    </h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubCategoryModal">
        <i class="fas fa-plus"></i> Yeni Alt Kategori
    </button>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Sıra</th>
                <th>Adı</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($list as $sub): ?>
            <tr>
                <td><?php echo $sub['rank_order']; ?></td>
                <td><?php echo $sub['name']; ?></td>
                <td>
                    <button class="btn btn-sm btn-outline-secondary edit-btn" 
                            data-id="<?php echo $sub['id']; ?>" 
                            data-name="<?php echo $sub['name']; ?>" 
                            data-rank="<?php echo $sub['rank_order']; ?>"
                            data-bs-toggle="modal" data-bs-target="#editSubCategoryModal">
                        <i class="fas fa-edit"></i>
                    </button>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $sub['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Ekleme Modalı -->
<div class="modal fade" id="addSubCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <input type="hidden" name="action" value="add">
            <div class="modal-header">
                <h5 class="modal-title">Yeni Alt Kategori Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Alt Kategori Adı</label>
                    <input type="text" class="form-control" name="name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Sıralama</label>
                    <input type="number" class="form-control" name="rank_order" value="0">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<!-- Düzenleme Modalı -->
<div class="modal fade" id="editSubCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <input type="hidden" name="action" value="edit">
            <input type="hidden" name="id" id="edit_id">
            <div class="modal-header">
                <h5 class="modal-title">Alt Kategori Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Alt Kategori Adı</label>
                    <input type="text" class="form-control" name="name" id="edit_name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Sıralama</label>
                    <input type="number" class="form-control" name="rank_order" id="edit_rank">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Güncelle</button>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var editModal = document.getElementById('editSubCategoryModal');
        editModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            editModal.querySelector('#edit_id').value = button.getAttribute('data-id');
            editModal.querySelector('#edit_name').value = button.getAttribute('data-name');
            editModal.querySelector('#edit_rank').value = button.getAttribute('data-rank');
        });
    });
</script>

<?php include 'includes/footer.php'; ?>
