<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";

if (isset($_POST['action'])) {
    if ($_POST['action'] == 'delete') {
        $id = (int)$_POST['id'];
        $stmt = $pdo->prepare("DELETE FROM important_numbers WHERE id = ?");
        if ($stmt->execute([$id])) $message = "Kayıt silindi.";
        else $error = "Silme hatalı.";
    } elseif ($_POST['action'] == 'add' || $_POST['action'] == 'edit') {
        $name = cleanInput($_POST['name']);
        $phone = cleanInput($_POST['phone']);
        $rank_order = (int)$_POST['rank_order'];

        if ($_POST['action'] == 'add') {
            $stmt = $pdo->prepare("INSERT INTO important_numbers (name, phone, rank_order) VALUES (?, ?, ?)");
            if ($stmt->execute([$name, $phone, $rank_order])) $message = "Eklendi.";
            else $error = "Ekleme hatası.";
        } else {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("UPDATE important_numbers SET name=?, phone=?, rank_order=? WHERE id=?");
            if ($stmt->execute([$name, $phone, $rank_order, $id])) $message = "Güncellendi.";
            else $error = "Güncelleme hatası.";
        }
    }
}

$numbers = $pdo->query("SELECT * FROM important_numbers ORDER BY rank_order ASC")->fetchAll();
include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Önemli Numaralar</h1>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#numberModal" onclick="resetForm()">
        <i class="fas fa-plus"></i> Yeni Ekle
    </button>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Sıra</th>
                <th>Ad / Kurum</th>
                <th>Telefon</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($numbers as $num): ?>
            <tr>
                <td><?php echo $num['rank_order']; ?></td>
                <td><?php echo $num['name']; ?></td>
                <td><?php echo $num['phone']; ?></td>
                <td>
                    <button class="btn btn-sm btn-outline-primary" 
                            onclick="editNum(<?php echo htmlspecialchars(json_encode($num)); ?>)">
                        <i class="fas fa-edit"></i>
                    </button>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $num['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Modal -->
<div class="modal fade" id="numberModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <input type="hidden" name="action" id="n_action" value="add">
            <input type="hidden" name="id" id="n_id">
            
            <div class="modal-header">
                <h5 class="modal-title" id="n_modal_title">Yeni Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Ad / Kurum</label>
                    <input type="text" class="form-control" name="name" id="n_name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Telefon</label>
                    <input type="text" class="form-control" name="phone" id="n_phone" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Sıralama</label>
                    <input type="number" class="form-control" name="rank_order" id="n_rank_order" value="0">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<script>
    function resetForm() {
        document.getElementById('n_action').value = 'add';
        document.getElementById('n_id').value = '';
        document.getElementById('n_name').value = '';
        document.getElementById('n_phone').value = '';
        document.getElementById('n_rank_order').value = '0';
        document.getElementById('n_modal_title').innerText = 'Yeni Ekle';
    }

    function editNum(data) {
        document.getElementById('n_action').value = 'edit';
        document.getElementById('n_id').value = data.id;
        document.getElementById('n_name').value = data.name;
        document.getElementById('n_phone').value = data.phone;
        document.getElementById('n_rank_order').value = data.rank_order;
        document.getElementById('n_modal_title').innerText = 'Düzenle';
        var myModal = new bootstrap.Modal(document.getElementById('numberModal'));
        myModal.show();
    }
</script>

<?php include 'includes/footer.php'; ?>
