<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";

// Bildirim Gönderme (Placeholder)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = cleanInput($_POST['title']);
    $body = cleanInput($_POST['body']);
    
    // Veritabanına kaydet
    $stmt = $pdo->prepare("INSERT INTO notifications (title, body) VALUES (?, ?)");
    $stmt->execute([$title, $body]);
    
    // Burada gerçek FCM API'sine istek gönderilecek
    // FCM Server Key olmadığı için şimdilik sadece kaydediyoruz
    $message = "Bildirim kuyruğa alındı ve veritabanına kaydedildi. (FCM Entegrasyonu için Server Key gerekli)";
}

$notifications = $pdo->query("SELECT * FROM notifications ORDER BY sent_at DESC")->fetchAll();

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Bildirim Gönder</h1>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Yeni Bildirim Oluştur</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Bildirim Başlığı</label>
                        <input type="text" class="form-control" name="title" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Bildirim İçeriği</label>
                        <textarea class="form-control" name="body" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-paper-plane"></i> Gönder</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Geçmiş Bildirimler</div>
            <div class="card-body">
                <ul class="list-group">
                    <?php foreach($notifications as $notif): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <strong><?php echo $notif['title']; ?></strong><br>
                            <small class="text-muted"><?php echo $notif['sent_at']; ?></small>
                            <p class="mb-0 small"><?php echo $notif['body']; ?></p>
                        </div>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
