<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";

if (isset($_POST['action']) && $_POST['action'] == 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $pdo->prepare("DELETE FROM news WHERE id = ?");
    if ($stmt->execute([$id])) $message = "Haber silindi.";
    else $error = "Silme hatalı.";
}

if (isset($_POST['action']) && ($_POST['action'] == 'add' || $_POST['action'] == 'edit')) {
    $title = cleanInput($_POST['title']);
    $content = $_POST['content']; 
    $source = cleanInput($_POST['source']); // Kaynak alanı
    
    $image_url = $_POST['current_image'] ?? null;
    
    try {
        if ($uploaded = uploadImage($_FILES['image'], '../uploads/', 'news_')) {
            $image_url = $uploaded;
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }

    if (empty($error)) {
        try {
            if ($_POST['action'] == 'add') {
                $stmt = $pdo->prepare("INSERT INTO news (title, content, source, image_url) VALUES (?, ?, ?, ?)");
                if ($stmt->execute([$title, $content, $source, $image_url])) $message = "Haber eklendi.";
                else $error = "Ekleme hatası.";
            } else {
                $id = (int)$_POST['id'];
                $stmt = $pdo->prepare("UPDATE news SET title=?, content=?, source=?, image_url=? WHERE id=?");
                if ($stmt->execute([$title, $content, $source, $image_url, $id])) $message = "Haber güncellendi.";
                else $error = "Güncelleme hatası.";
            }
        } catch (PDOException $e) {
            $error = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

$news_list = $pdo->query("SELECT * FROM news ORDER BY created_at DESC")->fetchAll();

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Haberler</h1>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#newsModal" onclick="resetForm()">
        <i class="fas fa-plus"></i> Yeni Haber
    </button>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Başlık</th>
                <th>Kaynak</th>
                <th>Tarih</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($news_list as $news): ?>
            <tr>
                <td><?php echo $news['title']; ?></td>
                <td><?php echo $news['source']; ?></td>
                <td><?php echo $news['created_at']; ?></td>
                <td>
                    <button class="btn btn-sm btn-outline-primary" 
                            onclick="editNews(<?php echo htmlspecialchars(json_encode($news)); ?>)">
                        <i class="fas fa-edit"></i>
                    </button>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $news['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<div class="modal fade" id="newsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form method="POST" class="modal-content" enctype="multipart/form-data">
            <input type="hidden" name="action" id="n_action" value="add">
            <input type="hidden" name="id" id="n_id">
            <input type="hidden" name="current_image" id="n_current_image">
            
            <div class="modal-header">
                <h5 class="modal-title" id="n_modal_title">Yeni Haber Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Başlık</label>
                    <input type="text" class="form-control" name="title" id="n_title" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Haber Kaynağı</label>
                    <input type="text" class="form-control" name="source" id="n_source" placeholder="Örn: Milliyet, Yerel Basın">
                </div>
                <div class="mb-3">
                    <label class="form-label">İçerik</label>
                    <textarea class="form-control" name="content" id="n_content" rows="5" required></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Görsel</label>
                    <input type="file" class="form-control" name="image">
                    <div id="n_image_preview" class="mt-2"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<script>
    function resetForm() {
        document.getElementById('n_action').value = 'add';
        document.getElementById('n_id').value = '';
        document.getElementById('n_title').value = '';
        document.getElementById('n_source').value = '';
        document.getElementById('n_content').value = '';
        document.getElementById('n_current_image').value = '';
        document.getElementById('n_image_preview').innerHTML = '';
        document.getElementById('n_modal_title').innerText = 'Yeni Haber Ekle';
    }

    function editNews(news) {
        document.getElementById('n_action').value = 'edit';
        document.getElementById('n_id').value = news.id;
        document.getElementById('n_title').value = news.title;
        document.getElementById('n_source').value = news.source;
        document.getElementById('n_content').value = news.content;
        document.getElementById('n_current_image').value = news.image_url;
        document.getElementById('n_modal_title').innerText = 'Haber Düzenle';
        
        if (news.image_url) {
            document.getElementById('n_image_preview').innerHTML = '<img src="../'+news.image_url+'" style="max-height:100px;">';
        } else {
            document.getElementById('n_image_preview').innerHTML = '';
        }

        var myModal = new bootstrap.Modal(document.getElementById('newsModal'));
        myModal.show();
    }
</script>

<?php include 'includes/footer.php'; ?>
