<?php
require_once 'auth.php';
require_once '../config/db.php';
include 'includes/header.php';

// İstatistikleri Getir
try {
    $firmCount = $pdo->query("SELECT COUNT(*) FROM firms")->fetchColumn();
    $catCount = $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn();
    $viewCount = $pdo->query("SELECT SUM(views) FROM firms")->fetchColumn();
    $viewCount = $viewCount ? $viewCount : 0;
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<div class="row">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h5 class="card-title">Toplam Firma</h5>
                <h2><i class="fas fa-building"></i> <?php echo $firmCount; ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h5 class="card-title">Kategoriler</h5>
                <h2><i class="fas fa-list"></i> <?php echo $catCount; ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h5 class="card-title">Toplam Görüntülenme</h5>
                <h2><i class="fas fa-eye"></i> <?php echo $viewCount; ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                Hızlı Başlangıç
            </div>
            <div class="card-body">
                <p>Hoş geldiniz, <strong><?php echo $_SESSION['admin_username']; ?></strong>.</p>
                <p>Sol menüden kategori ekleyebilir, firma düzenleyebilir veya Excel ile toplu veri yükleyebilirsiniz.</p>
                <a href="import.php" class="btn btn-outline-primary"><i class="fas fa-file-excel"></i> Excel İçe Aktar</a>
                <a href="firms.php" class="btn btn-outline-secondary"><i class="fas fa-plus"></i> Yeni Firma Ekle</a>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
