<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ulucak Rehber - Yönetim Paneli</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .wrapper {
            display: flex;
            flex: 1;
        }
        #sidebar {
            min-width: 250px;
            max-width: 250px;
            min-height: 100vh;
            background: #212529;
            color: #fff;
            transition: all 0.3s;
        }
        #sidebar .nav-link {
            color: rgba(255,255,255,.8);
            padding: 15px 20px;
            border-bottom: 1px solid rgba(255,255,255,.1);
        }
        #sidebar .nav-link:hover, #sidebar .nav-link.active {
            color: #fff;
            background: #343a40;
        }
        #sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        #content {
            width: 100%;
            padding: 20px;
            background: #f8f9fa;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
            border: none;
            margin-bottom: 20px;
        }
        .card-header {
            background-color: #fff;
            border-bottom: 1px solid rgba(0,0,0,.125);
            font-weight: 600;
        }
    </style>
</head>
<body>

<div class="wrapper">
    <!-- Sidebar -->
    <nav id="sidebar">
        <div class="sidebar-header p-3">
            <h3><i class="fas fa-tools me-2"></i>Admin</h3>
        </div>

        <ul class="list-unstyled components">
            <li>
                <a href="index.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i> Panel
                </a>
            </li>
            <li>
                <a href="categories.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' || basename($_SERVER['PHP_SELF']) == 'subcategories.php' ? 'active' : ''; ?>">
                    <i class="fas fa-list"></i> Kategoriler
                </a>
            </li>
            <li>
                <a href="firms.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'firms.php' || basename($_SERVER['PHP_SELF']) == 'firm_edit.php' ? 'active' : ''; ?>">
                    <i class="fas fa-building"></i> Firmalar
                </a>
            </li>
            <li>
                <a href="news.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'news.php' ? 'active' : ''; ?>">
                    <i class="fas fa-newspaper"></i> Haberler
                </a>
            </li>
            <li>
                <a href="events.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'events.php' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar-alt"></i> Etkinlikler
                </a>
            </li>
            <li>
                <a href="numbers.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'numbers.php' ? 'active' : ''; ?>">
                    <i class="fas fa-phone"></i> Önemli Numaralar
                </a>
            </li>
            <li>
                <a href="notifications.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'notifications.php' ? 'active' : ''; ?>">
                    <i class="fas fa-bell"></i> Bildirimler
                </a>
            </li>
            <li>
                <a href="import.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'import.php' ? 'active' : ''; ?>">
                    <i class="fas fa-file-excel"></i> Excel İçe Aktar
                </a>
            </li>
            <li>
                <a href="logout.php" class="nav-link">
                    <i class="fas fa-sign-out-alt"></i> Çıkış Yap
                </a>
            </li>
        </ul>
    </nav>

    <!-- Page Content -->
    <div id="content">
        <nav class="navbar navbar-expand-lg navbar-light bg-light rounded mb-4 shadow-sm">
            <div class="container-fluid">
                <button type="button" id="sidebarCollapse" class="btn btn-dark">
                    <i class="fas fa-bars"></i>
                </button>
                <span class="navbar-brand ms-3">Ulucak Rehber Yönetim Paneli</span>
            </div>
        </nav>
