<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";
$step = 1; // 1: Kategori Seç + Upload, 2: Preview/Map, 3: Process

// Veritabanı sütunları ve Türkçe karşılıkları (Otomatik eşleşme için)
$db_cols = [
    'name' => ['label' => 'Firma Adı', 'keywords' => ['ad', 'adi', 'isim', 'firma', 'name', 'title']],
    'owner' => ['label' => 'Yetkili / Usta', 'keywords' => ['yetkili', 'sahibi', 'usta', 'owner', 'contact']],
    'phone' => ['label' => 'Telefon', 'keywords' => ['tel', 'telefon', 'phone', 'gsm', 'mobil']],
    'whatsapp' => ['label' => 'Whatsapp', 'keywords' => ['up', 'what', 'wp', 'whatsapp']],
    'address' => ['label' => 'Adres', 'keywords' => ['adres', 'konum', 'yer', 'address', 'loc']],
    'description' => ['label' => 'Açıklama', 'keywords' => ['aciklama', 'desc', 'description', 'not']],
    'latitude' => ['label' => 'Enlem', 'keywords' => ['enlem', 'lat', 'latitude']],
    'longitude' => ['label' => 'Boylam', 'keywords' => ['boylam', 'lon', 'lng', 'longitude']]
];

// Kategorileri ve Alt Kategorileri Çek
$categories = $pdo->query("SELECT * FROM categories ORDER BY name ASC")->fetchAll();
$subcategories_raw = $pdo->query("SELECT * FROM subcategories ORDER BY rank_order ASC")->fetchAll();
$subcategories_json = [];
foreach($subcategories_raw as $sc) $subcategories_json[$sc['category_id']][] = $sc;

// Dosya Yüklendiğinde
if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] == 0) {
    $file = $_FILES['csv_file']['tmp_name'];
    $filename = $_FILES['csv_file']['name'];
    $ext = pathinfo($filename, PATHINFO_EXTENSION);
    
    // Seçilen kategori ve alt kategori
    $selected_category_id = isset($_POST['category_id']) ? (int)$_POST['category_id'] : 0;
    $selected_subcategory_id = isset($_POST['subcategory_id']) && $_POST['subcategory_id'] !== '' ? (int)$_POST['subcategory_id'] : null;
    
    if ($selected_category_id == 0) {
        $error = "Lütfen bir ana kategori seçin.";
    } elseif (strtolower($ext) !== 'csv') {
        $error = "Lütfen sadece CSV dosyası yükleyin. Excel dosyanızı 'Farklı Kaydet' diyerek CSV formatına çevirebilirsiniz.";
    } else {
        // Dosyayı geçici klasöre taşı (işlemek için)
        $target_file = '../uploads/import_temp.csv';
        move_uploaded_file($file, $target_file);
        
        // Kategori bilgilerini session'a kaydet
        $_SESSION['import_category_id'] = $selected_category_id;
        $_SESSION['import_subcategory_id'] = $selected_subcategory_id;
        
        // CSV Başlıklarını Oku
        if (($handle = fopen($target_file, "r")) !== FALSE) {
            // BOM kontrolü ve temizliği
            $bom = fread($handle, 3);
            if ($bom != "\xEF\xBB\xBF") rewind($handle);
            
            $headers = fgetcsv($handle, 1000, ";"); // Noktalı virgül dene
            if (!$headers || count($headers) < 2) {
                rewind($handle);
                $headers = fgetcsv($handle, 1000, ","); // Virgül dene
            }
            fclose($handle);
            
            $step = 2; // Eşleştirme adımına geç
        } else {
            $error = "Dosya okunamadı.";
        }
    }
}

// İçe Aktarma İşlemi Başlatıldığında
if (isset($_POST['import_data'])) {
    $mapping = $_POST['map']; // Array: db_col => csv_index
    $target_file = '../uploads/import_temp.csv';
    
    // Session'dan kategori bilgilerini al
    $cat_id = $_SESSION['import_category_id'] ?? null;
    $sub_cat_id = $_SESSION['import_subcategory_id'] ?? null;
    
    if (!$cat_id) {
        $error = "Kategori bilgisi bulunamadı. Lütfen tekrar deneyin.";
    } elseif (file_exists($target_file)) {
        if (($handle = fopen($target_file, "r")) !== FALSE) {
            // Başlığı atla
            // BOM kontrolü
            $bom = fread($handle, 3);
            if ($bom != "\xEF\xBB\xBF") rewind($handle);
            $dummy = fgetcsv($handle, 1000, ";");
            if (!$dummy || count($dummy) < 2) {
                rewind($handle);
                if ($bom != "\xEF\xBB\xBF") rewind($handle);
                fgetcsv($handle, 1000, ",");
            }

            $success_count = 0;
            $fail_count = 0;

            while (($data = fgetcsv($handle, 1000, count($dummy) > 2 ? ";" : ",")) !== FALSE) {
                // Verileri Eşleştir
                $row = [];
                foreach ($mapping as $db_key => $csv_index) {
                    if ($csv_index !== "") {
                        $val = isset($data[$csv_index]) ? trim($data[$csv_index]) : '';
                        $row[$db_key] = $val;
                    } else {
                        $row[$db_key] = '';
                    }
                }

                // Veritabanına Ekle (Mükerrer Kontrolü - İsim ve Tel aynıysa ekleme)
                $check = $pdo->prepare("SELECT id FROM firms WHERE name = ? AND phone = ?");
                $check->execute([$row['name'], $row['phone']]);
                if (!$check->fetch()) {
                    $insert = $pdo->prepare("INSERT INTO firms (name, owner, category_id, subcategory_id, phone, whatsapp, address, description, latitude, longitude, is_active) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)");
                    if ($insert->execute([
                        $row['name'], 
                        $row['owner'] ?? '', 
                        $cat_id, 
                        $sub_cat_id,
                        $row['phone'] ?? '', 
                        $row['whatsapp'] ?? '', 
                        $row['address'] ?? '',
                        $row['description'] ?? '',
                        !empty($row['latitude']) ? (float)$row['latitude'] : null, 
                        !empty($row['longitude']) ? (float)$row['longitude'] : null
                    ])) {
                        $success_count++;
                    } else {
                        $fail_count++;
                    }
                } else {
                    $fail_count++; // Mükerrer
                }
            }
            fclose($handle);
            unlink($target_file); // Dosyayı sil
            
            // Session temizle
            unset($_SESSION['import_category_id']);
            unset($_SESSION['import_subcategory_id']);
            
            $message = "İşlem Tamamlandı: $success_count kayıt eklendi, $fail_count kayıt atlandı (mükerrer veya hatalı).";
            $step = 1; // Başa dön
        }
    } else {
        $error = "İşlenecek dosya bulunamadı.";
    }
}

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Toplu Veri Yükleme (Excel/CSV)</h1>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<?php if($step == 1): ?>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Adım 1: Kategori Seç ve Dosya Yükle</h5>
        <p class="card-text">
            Önce yüklenecek firmaların hangi kategoriye ait olduğunu seçin, ardından CSV dosyasını yükleyin.<br>
            <small class="text-muted">Excel dosyanızı "Farklı Kaydet" diyerek "CSV (Virgülle ayrılmış)" formatında kaydedebilirsiniz.</small>
        </p>
        
        <form method="POST" enctype="multipart/form-data">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label">Ana Kategori *</label>
                    <select class="form-select" name="category_id" id="category_select" required onchange="updateSubCats()">
                        <option value="">Seçiniz...</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Alt Kategori (Opsiyonel)</label>
                    <select class="form-select" name="subcategory_id" id="subcategory_select">
                        <option value="">Seçiniz...</option>
                    </select>
                </div>
            </div>
            
            <div class="mb-3">
                <label for="csv_file" class="form-label">CSV Dosyası Seç *</label>
                <input class="form-control" type="file" id="csv_file" name="csv_file" required accept=".csv">
            </div>
            <button type="submit" class="btn btn-primary">Devam Et <i class="fas fa-arrow-right"></i></button>
        </form>
    </div>
</div>

<script>
var subcats = <?php echo json_encode($subcategories_json); ?>;

function updateSubCats() {
    var catId = document.getElementById('category_select').value;
    var subSelect = document.getElementById('subcategory_select');
    subSelect.innerHTML = '<option value="">Seçiniz...</option>';

    if (subcats[catId]) {
        subcats[catId].forEach(function(sc) {
            var opt = document.createElement('option');
            opt.value = sc.id;
            opt.innerHTML = sc.name;
            subSelect.appendChild(opt);
        });
    }
}
</script>

<?php elseif($step == 2): 
    // Seçilen kategorilerin isimlerini göster
    $cat_name = "";
    $subcat_name = "";
    foreach($categories as $cat) {
        if ($cat['id'] == $_SESSION['import_category_id']) {
            $cat_name = $cat['name'];
            break;
        }
    }
    foreach($subcategories_raw as $sc) {
        if ($sc['id'] == $_SESSION['import_subcategory_id']) {
            $subcat_name = $sc['name'];
            break;
        }
    }
?>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Adım 2: Sütun Eşleştirme</h5>
        <div class="alert alert-info">
            <strong>Seçilen Kategori:</strong> <?php echo htmlspecialchars($cat_name); ?>
            <?php if($subcat_name): ?>
                <strong>/ Alt Kategori:</strong> <?php echo htmlspecialchars($subcat_name); ?>
            <?php endif; ?>
        </div>
        <p>CSV dosyanızdaki sütunları veritabanı alanlarıyla eşleştirin.</p>
        
        <form method="POST">
            <input type="hidden" name="import_data" value="1">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Veritabanı Alanı</th>
                            <th>CSV Sütunu</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($db_cols as $db_key => $col_info): ?>
                        <tr>
                            <td>
                                <strong><?php echo $col_info['label']; ?></strong>
                                <?php if($db_key == 'name') echo '<span class="text-danger">*</span>'; ?>
                            </td>
                            <td>
                                <select name="map[<?php echo $db_key; ?>]" class="form-select">
                                    <option value="">-- Seçiniz --</option>
                                    <?php foreach($headers as $index => $header_name): 
                                        // Basit otomatik eşleştirme mantığı
                                        $selected = '';
                                        $h_clean = mb_strtolower(trim($header_name));
                                        foreach($col_info['keywords'] as $keyword) {
                                            if (strpos($h_clean, $keyword) !== false) {
                                                $selected = 'selected';
                                                break;
                                            }
                                        }
                                    ?>
                                        <option value="<?php echo $index; ?>" <?php echo $selected; ?>>
                                            <?php echo htmlspecialchars($header_name); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                <a href="import.php" class="btn btn-secondary">İptal</a>
                <button type="submit" class="btn btn-success">İçe Aktarmayı Başlat</button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>
