<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";

// Silme İşlemi
if (isset($_POST['action']) && $_POST['action'] == 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $pdo->prepare("DELETE FROM firms WHERE id = ?");
    if ($stmt->execute([$id])) {
        $message = "Firma silindi.";
    } else {
        $error = "Silme hatalı.";
    }
}

// Firmaları Listele (Basit sayfalama yapılabilir ama şimdilik hepsi)
// Arama varsa
$search = $_GET['search'] ?? '';
$sql = "SELECT f.*, c.name as cat_name FROM firms f LEFT JOIN categories c ON f.category_id = c.id";
$params = [];
if ($search) {
    $sql .= " WHERE f.name LIKE ? OR f.owner LIKE ?";
    $params = ["%$search%", "%$search%"];
}
$sql .= " ORDER BY f.id DESC LIMIT 100"; // Performans için limit
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$firms = $stmt->fetchAll();
include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Firmalar</h1>
    <div>
        <!-- Arama Formu -->
        <form class="d-inline-flex me-2" method="GET">
            <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Firma Ara..." value="<?php echo htmlspecialchars($search); ?>">
            <button type="submit" class="btn btn-sm btn-outline-secondary"><i class="fas fa-search"></i></button>
        </form>
        <a href="firm_edit.php" class="btn btn-primary">
            <i class="fas fa-plus"></i> Yeni Firma
        </a>
    </div>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped table-hover table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Firma Adı</th>
                <th>Kategori</th>
                <th>Telefon</th>
                <th>Whatsapp</th>
                <th>Durum</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($firms as $firm): ?>
            <tr>
                <td><?php echo $firm['id']; ?></td>
                <td>
                    <?php echo $firm['name']; ?>
                    <br><small class="text-muted"><?php echo $firm['owner']; ?></small>
                </td>
                <td><?php echo $firm['cat_name']; ?></td>
                <td><?php echo $firm['phone']; ?></td>
                <td>
                    <?php if($firm['whatsapp']): ?>
                        <a href="https://wa.me/90<?php echo str_replace([' ', '-', '(', ')'], '', $firm['whatsapp']); ?>" target="_blank" class="text-success"><i class="fab fa-whatsapp"></i></a>
                    <?php endif; ?>
                </td>
                <td>
                    <?php echo $firm['is_active'] ? '<span class="badge bg-success">Aktif</span>' : '<span class="badge bg-secondary">Pasif</span>'; ?>
                    <?php if(!empty($firm['is_featured'])) echo '<span class="badge bg-warning text-dark"><i class="fas fa-star"></i> Vitrin</span>'; ?>
                </td>
                <td>
                    <a href="firm_edit.php?id=<?php echo $firm['id']; ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $firm['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include 'includes/footer.php'; ?>
