<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$action = $id ? 'edit' : 'add';
$message = "";
$error = "";

// Varsayılan Değerler
$firm = [
    'name' => '', 'description' => '', 'owner' => '', 'category_id' => '', 'subcategory_id' => '',
    'phone' => '', 'whatsapp' => '', 'address' => '', 
    'latitude' => '', 'longitude' => '', 
    'image_url' => '', 'logo_url' => '',
    'content' => '', 'working_hours' => '', 'website' => '', 'email' => '',
    'is_featured' => 0, 'rating' => 0, 'is_active' => 1
];

if ($id) {
    $stmt = $pdo->prepare("SELECT * FROM firms WHERE id = ?");
    $stmt->execute([$id]);
    $fetched = $stmt->fetch();
    if ($fetched) $firm = $fetched;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $data = [
        'name' => cleanInput($_POST['name']),
        'description' => cleanInput($_POST['description']),
        'owner' => cleanInput($_POST['owner']),
        'category_id' => (int)$_POST['category_id'],
        'subcategory_id' => !empty($_POST['subcategory_id']) ? (int)$_POST['subcategory_id'] : null,
        'phone' => cleanInput($_POST['phone']),
        'whatsapp' => cleanInput($_POST['whatsapp']),
        'address' => cleanInput($_POST['address']),
        'latitude' => $_POST['latitude'] ?: null,
        'longitude' => $_POST['longitude'] ?: null,
        'content' => $_POST['content'], 
        'working_hours' => cleanInput($_POST['working_hours']),
        'website' => cleanInput($_POST['website']),
        'email' => cleanInput($_POST['email']),
        'is_featured' => isset($_POST['is_featured']) ? 1 : 0,
        'rating' => (float)$_POST['rating'],
        'is_active' => isset($_POST['is_active']) ? 1 : 0
    ];

    // Resim Upload İşlemleri
    try {
        if ($uploaded = uploadImage($_FILES['image'], '../uploads/', 'firm_')) {
            $data['image_url'] = $uploaded;
        } else {
            $data['image_url'] = $firm['image_url'];
        }

        if ($uploadedLogo = uploadImage($_FILES['logo'], '../uploads/', 'logo_')) {
            $data['logo_url'] = $uploadedLogo;
        } else {
            $data['logo_url'] = $firm['logo_url'];
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }

    if (empty($error)) {
        $cols = implode(", ", array_keys($data));
        $vals = ":" . implode(", :", array_keys($data));
        
        if ($action == 'add') {
            $sql = "INSERT INTO firms ($cols) VALUES ($vals)";
        } else {
            $set = "";
            foreach($data as $k => $v) $set .= "$k=:$k, ";
            $set = rtrim($set, ", ");
            $sql = "UPDATE firms SET $set WHERE id=$id";
        }

        try {
            $stmt = $pdo->prepare($sql);
            $stmt->execute($data);
            $message = "Kayıt başarılı.";
            if ($action == 'add') { header("Location: firms.php"); exit; }
            $firm = array_merge($firm, $data);
        } catch (PDOException $e) {
            $error = "Hata: " . $e->getMessage();
        }
    }
}

$categories = $pdo->query("SELECT * FROM categories ORDER BY name ASC")->fetchAll();
$subcategories_raw = $pdo->query("SELECT * FROM subcategories ORDER BY rank_order ASC")->fetchAll();
$subcategories_json = [];
foreach($subcategories_raw as $sc) $subcategories_json[$sc['category_id']][] = $sc;

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?php echo $id ? 'Firma Düzenle' : 'Yeni Firma Ekle'; ?></h1>
    <a href="firms.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Geri Dön</a>
</div>
<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<form method="POST" enctype="multipart/form-data">
    <div class="row">
        <div class="col-md-8">
            <div class="card mb-3">
                <div class="card-header">Temel Bilgiler</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Firma Adı *</label>
                        <input type="text" class="form-control" name="name" value="<?php echo $firm['name']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kısa Açıklama (Description)</label>
                        <input type="text" class="form-control" name="description" value="<?php echo $firm['description']; ?>">
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Yetkili Kişi</label>
                            <input type="text" class="form-control" name="owner" value="<?php echo $firm['owner']; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Çalışma Saatleri</label>
                            <input type="text" class="form-control" name="working_hours" value="<?php echo $firm['working_hours']; ?>" placeholder="09:00 - 18:00">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Web Sitesi</label>
                            <input type="text" class="form-control" name="website" value="<?php echo $firm['website']; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">E-posta</label>
                            <input type="email" class="form-control" name="email" value="<?php echo $firm['email']; ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Kategori *</label>
                            <select class="form-select" name="category_id" id="category_select" required onchange="updateSubCats()">
                                <option value="">Seçiniz...</option>
                                <?php foreach($categories as $cat): ?>
                                    <option value="<?php echo $cat['id']; ?>" <?php echo $firm['category_id'] == $cat['id'] ? 'selected' : ''; ?>>
                                        <?php echo $cat['name']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Alt Kategori</label>
                            <select class="form-select" name="subcategory_id" id="subcategory_select">
                                <option value="">Seçiniz...</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Detaylı İçerik</label>
                        <textarea class="form-control" name="content" rows="4"><?php echo $firm['content']; ?></textarea>
                    </div>
                </div>
            </div>
            
            <div class="card mb-3">
                <div class="card-header">İletişim & Konum</div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Telefon</label>
                            <input type="text" class="form-control" name="phone" value="<?php echo $firm['phone']; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Whatsapp</label>
                            <input type="text" class="form-control" name="whatsapp" value="<?php echo $firm['whatsapp']; ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Adres</label>
                        <textarea class="form-control" name="address" rows="2"><?php echo $firm['address']; ?></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Enlem</label>
                            <input type="text" class="form-control" name="latitude" value="<?php echo $firm['latitude']; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Boylam</label>
                            <input type="text" class="form-control" name="longitude" value="<?php echo $firm['longitude']; ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header">Görünürlük</div>
                <div class="card-body">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" name="is_active" id="isActive" <?php echo $firm['is_active'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="isActive">Aktif</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" name="is_featured" id="isFeatured" <?php echo $firm['is_featured'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="isFeatured">Vitrine Ekle</label>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Puan (Rating)</label>
                        <input type="number" step="0.1" class="form-control" name="rating" value="<?php echo $firm['rating']; ?>">
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div class="card-header">Görseller</div>
                <div class="card-body">
                    <label class="form-label">Ana Görsel</label>
                    <?php if($firm['image_url']): ?>
                        <img src="../<?php echo $firm['image_url']; ?>" class="img-fluid mb-2 rounded d-block" style="max-height: 150px;">
                    <?php endif; ?>
                    <input type="file" class="form-control mb-3" name="image">

                    <label class="form-label">Logo</label>
                    <?php if($firm['logo_url']): ?>
                        <img src="../<?php echo $firm['logo_url']; ?>" class="img-fluid mb-2 rounded d-block" style="max-height: 100px;">
                    <?php endif; ?>
                    <input type="file" class="form-control" name="logo">
                </div>
            </div>
            
            <button type="submit" class="btn btn-success w-100 btn-lg"><i class="fas fa-save"></i> Kaydet</button>
        </div>
    </div>
</form>

<script>
    var subcats = <?php echo json_encode($subcategories_json); ?>;
    var selectedSubCat = "<?php echo $firm['subcategory_id']; ?>";

    function updateSubCats() {
        var catId = document.getElementById('category_select').value;
        var subSelect = document.getElementById('subcategory_select');
        subSelect.innerHTML = '<option value="">Seçiniz...</option>';

        if (subcats[catId]) {
            subcats[catId].forEach(function(sc) {
                var opt = document.createElement('option');
                opt.value = sc.id;
                opt.innerHTML = sc.name;
                if(sc.id == selectedSubCat) opt.selected = true;
                subSelect.appendChild(opt);
            });
        }
    }
    updateSubCats();
</script>

<?php include 'includes/footer.php'; ?>
