<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";

if (isset($_POST['action']) && $_POST['action'] == 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $pdo->prepare("DELETE FROM events WHERE id = ?");
    if ($stmt->execute([$id])) $message = "Etkinlik silindi.";
    else $error = "Silme hatalı.";
}

if (isset($_POST['action']) && ($_POST['action'] == 'add' || $_POST['action'] == 'edit')) {
    $title = cleanInput($_POST['title']);
    $description = cleanInput($_POST['description']);
    $event_date = $_POST['event_date'];
    $location = cleanInput($_POST['location']);
    $organizer = cleanInput($_POST['organizer']);
    $contact = cleanInput($_POST['contact']);
    $latitude = !empty($_POST['latitude']) ? $_POST['latitude'] : null;
    $longitude = !empty($_POST['longitude']) ? $_POST['longitude'] : null;
    
    $image_url = $_POST['current_image'] ?? null;
    
    try {
        if ($uploaded = uploadImage($_FILES['image'], '../uploads/', 'event_')) {
            $image_url = $uploaded;
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }

    if (empty($error)) {
        $cols = "title, description, event_date, location, organizer, image_url, contact, latitude, longitude";
        
        try {
            if ($_POST['action'] == 'add') {
                $stmt = $pdo->prepare("INSERT INTO events ($cols) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                if ($stmt->execute([$title, $description, $event_date, $location, $organizer, $image_url, $contact, $latitude, $longitude])) 
                    $message = "Etkinlik eklendi.";
                else $error = "Ekleme hatası.";
            } else {
                $id = (int)$_POST['id'];
                $stmt = $pdo->prepare("UPDATE events SET title=?, description=?, event_date=?, location=?, organizer=?, image_url=?, contact=?, latitude=?, longitude=? WHERE id=?");
                if ($stmt->execute([$title, $description, $event_date, $location, $organizer, $image_url, $contact, $latitude, $longitude, $id])) 
                    $message = "Etkinlik güncellendi.";
                else $error = "Güncelleme hatası.";
            }
        } catch (PDOException $e) {
            $error = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

$events = $pdo->query("SELECT * FROM events ORDER BY event_date ASC")->fetchAll();

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Etkinlikler</h1>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#eventModal" onclick="resetForm()">
        <i class="fas fa-plus"></i> Yeni Etkinlik
    </button>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Tarih</th>
                <th>Etkinlik</th>
                <th>Konum / Düzenleyen</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($events as $event): ?>
            <tr>
                <td><?php echo date('d.m.Y H:i', strtotime($event['event_date'])); ?></td>
                <td><?php echo $event['title']; ?></td>
                <td>
                    <?php echo $event['location']; ?><br>
                    <small class="text-muted"><?php echo $event['organizer']; ?></small>
                </td>
                <td>
                    <button class="btn btn-sm btn-outline-primary" 
                            onclick="editEvent(<?php echo htmlspecialchars(json_encode($event)); ?>)">
                        <i class="fas fa-edit"></i>
                    </button>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $event['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<div class="modal fade" id="eventModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content" enctype="multipart/form-data">
            <input type="hidden" name="action" id="e_action" value="add">
            <input type="hidden" name="id" id="e_id">
            <input type="hidden" name="current_image" id="e_current_image">
            
            <div class="modal-header">
                <h5 class="modal-title" id="e_modal_title">Yeni Etkinlik Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Etkinlik Adı</label>
                    <input type="text" class="form-control" name="title" id="e_title" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Açıklama</label>
                    <textarea class="form-control" name="description" id="e_description" rows="3"></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Tarih ve Saat</label>
                    <input type="datetime-local" class="form-control" name="event_date" id="e_event_date" required>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Konum</label>
                        <input type="text" class="form-control" name="location" id="e_location">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Düzenleyen</label>
                        <input type="text" class="form-control" name="organizer" id="e_organizer">
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">İletişim</label>
                    <input type="text" class="form-control" name="contact" id="e_contact">
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Lat</label>
                        <input type="text" class="form-control" name="latitude" id="e_latitude">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Long</label>
                        <input type="text" class="form-control" name="longitude" id="e_longitude">
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Görsel</label>
                    <input type="file" class="form-control" name="image">
                    <div id="e_image_preview" class="mt-2"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<script>
    function resetForm() {
        document.getElementById('e_action').value = 'add';
        document.getElementById('e_id').value = '';
        document.getElementById('e_title').value = '';
        document.getElementById('e_description').value = '';
        document.getElementById('e_location').value = '';
        document.getElementById('e_organizer').value = '';
        document.getElementById('e_contact').value = '';
        document.getElementById('e_latitude').value = '';
        document.getElementById('e_longitude').value = '';
        document.getElementById('e_current_image').value = '';
        document.getElementById('e_image_preview').innerHTML = '';
        document.getElementById('e_modal_title').innerText = 'Yeni Etkinlik Ekle';
    }

    function editEvent(event) {
        document.getElementById('e_action').value = 'edit';
        document.getElementById('e_id').value = event.id;
        document.getElementById('e_title').value = event.title;
        document.getElementById('e_description').value = event.description;
        document.getElementById('e_event_date').value = event.event_date.replace(' ', 'T');
        document.getElementById('e_location').value = event.location;
        document.getElementById('e_organizer').value = event.organizer;
        document.getElementById('e_contact').value = event.contact;
        document.getElementById('e_latitude').value = event.latitude;
        document.getElementById('e_longitude').value = event.longitude;
        document.getElementById('e_current_image').value = event.image_url;
        document.getElementById('e_modal_title').innerText = 'Etkinliği Düzenle';
        
        if (event.image_url) {
            document.getElementById('e_image_preview').innerHTML = '<img src="../'+event.image_url+'" style="max-height:100px;">';
        } else {
            document.getElementById('e_image_preview').innerHTML = '';
        }

        var myModal = new bootstrap.Modal(document.getElementById('eventModal'));
        myModal.show();
    }
</script>

<?php include 'includes/footer.php'; ?>
