<?php
require_once 'auth.php';
require_once '../config/db.php';
require_once '../config/functions.php';

$message = "";
$error = "";

// Ekleme / Güncelleme İşlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    $name = cleanInput($_POST['name']);
    $rank_order = (int)$_POST['rank_order'];

    if (empty($name)) {
        $error = "Kategori adı boş olamaz.";
    } else {
        if ($action == 'add') {
            $slug = strtolower(str_replace(' ', '-', $name)); // Basit slug
            $stmt = $pdo->prepare("INSERT INTO categories (name, slug, rank_order) VALUES (?, ?, ?)");
            if ($stmt->execute([$name, $slug, $rank_order])) {
                $message = "Kategori başarıyla eklendi.";
            } else {
                $error = "Ekleme başarısız.";
            }
        } elseif ($action == 'edit') {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("UPDATE categories SET name = ?, rank_order = ? WHERE id = ?");
            if ($stmt->execute([$name, $rank_order, $id])) {
                $message = "Kategori güncellendi.";
            } else {
                $error = "Güncelleme başarısız.";
            }
        } elseif ($action == 'delete') {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("DELETE FROM categories WHERE id = ?");
            if ($stmt->execute([$id])) {
                $message = "Kategori silindi.";
            } else {
                $error = "Silme başarısız (bağlı firma olabilir).";
            }
        }
    }
}

// Kategorileri Listele
$categories = $pdo->query("SELECT * FROM categories ORDER BY rank_order ASC")->fetchAll();

include 'includes/header.php';
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Kategoriler</h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
        <i class="fas fa-plus"></i> Yeni Ekle
    </button>
</div>

<?php if($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Sıra</th>
                <th>Adı</th>
                <th>Oluşturulma</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($categories as $cat): ?>
            <tr>
                <td><?php echo $cat['rank_order']; ?></td>
                <td><?php echo $cat['name']; ?></td>
                <td><?php echo $cat['created_at']; ?></td>
                <td>
                    <a href="subcategories.php?cat_id=<?php echo $cat['id']; ?>" class="btn btn-sm btn-info text-white">
                        <i class="fas fa-code-branch"></i> Alt Kategoriler
                    </a>
                    <button class="btn btn-sm btn-outline-secondary edit-btn" 
                            data-id="<?php echo $cat['id']; ?>" 
                            data-name="<?php echo $cat['name']; ?>" 
                            data-rank="<?php echo $cat['rank_order']; ?>"
                            data-bs-toggle="modal" data-bs-target="#editCategoryModal">
                        <i class="fas fa-edit"></i>
                    </button>
                    <form method="POST" style="display:inline-block;" onsubmit="return confirm('Silmek istediğinize emin misiniz?');">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="<?php echo $cat['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Ekleme Modalı -->
<div class="modal fade" id="addCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <input type="hidden" name="action" value="add">
            <div class="modal-header">
                <h5 class="modal-title">Yeni Kategori Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Kategori Adı</label>
                    <input type="text" class="form-control" name="name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Sıralama</label>
                    <input type="number" class="form-control" name="rank_order" value="0">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<!-- Düzenleme Modalı -->
<div class="modal fade" id="editCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <form method="POST" class="modal-content">
            <input type="hidden" name="action" value="edit">
            <input type="hidden" name="id" id="edit_id">
            <div class="modal-header">
                <h5 class="modal-title">Kategori Düzenle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Kategori Adı</label>
                    <input type="text" class="form-control" name="name" id="edit_name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Sıralama</label>
                    <input type="number" class="form-control" name="rank_order" id="edit_rank">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="submit" class="btn btn-primary">Güncelle</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Düzenleme modalına verileri aktar
    document.addEventListener('DOMContentLoaded', function () {
        var editModal = document.getElementById('editCategoryModal');
        editModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var id = button.getAttribute('data-id');
            var name = button.getAttribute('data-name');
            var rank = button.getAttribute('data-rank');
            
            editModal.querySelector('#edit_id').value = id;
            editModal.querySelector('#edit_name').value = name;
            editModal.querySelector('#edit_rank').value = rank;
        });
    });
</script>

<?php include 'includes/footer.php'; ?>
